/*
 * Decompiled with CFR 0.152.
 */
package pl.indevo.pi.directory.api.channels;

import com.sap.xi.basis.RestrictedCommunicationChannel;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Properties;
import pl.indevo.pi.directory.api.channels.CChannelFile;
import pl.indevo.pi.directory.api.channels.CChannelService;
import pl.indevo.pi.directory.api.commons.Connection;
import pl.indevo.pi.directory.api.commons.Parameters;

public final class Channels {
    private Parameters params;
    private Connection connection;

    public static void main(String[] args) {
        Parameters params = new Parameters(args);
        System.out.println("------------------------------------------------------------");
        System.out.println("| INDEVO.PL                                                |");
        System.out.println("| SAP PI/PO Mass Communication Channels Update             |");
        System.out.println("| Version 1.0.2                                            |");
        System.out.println("------------------------------------------------------------");
        try {
            Channels channels = new Channels(params);
            if (params.contains("update")) {
                channels.update();
            } else {
                channels.list();
            }
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    private Channels(Parameters params) throws FileNotFoundException, IOException {
        if (this.invalidParams(params)) {
            this.printUsage();
            System.exit(1);
        }
        this.params = params;
        this.createConnection();
    }

    private void list() throws UnsupportedEncodingException, FileNotFoundException, MalformedURLException {
        System.out.println(String.format("Output file: %s", this.params.getString("list")));
        CChannelService channelSrv = new CChannelService();
        channelSrv.setConnection(this.connection);
        channelSrv.setParameters(this.params);
        channelSrv.list();
        System.out.println("Done!");
    }

    private void update() throws IOException {
        CChannelFile file = new CChannelFile();
        List<RestrictedCommunicationChannel> channels = file.parse(this.params.getString("update"));
        CChannelService channelSrv = new CChannelService();
        channelSrv.setConnection(this.connection);
        channelSrv.setParameters(this.params);
        channelSrv.update(channels);
        System.out.println("Done!");
    }

    private void createConnection() throws FileNotFoundException, IOException {
        this.connection = new Connection();
        if (this.params.hasValue("connection")) {
            Properties connProperties = new Properties();
            connProperties.load(new FileInputStream(this.params.getString("connection")));
            this.connection.setProtocol(connProperties.getProperty("protocol"));
            this.connection.setHost(connProperties.getProperty("host"));
            this.connection.setPort(Integer.parseInt(connProperties.getProperty("port")));
            this.connection.setUsername(connProperties.getProperty("user"));
            this.connection.setPassword(connProperties.getProperty("password"));
        } else {
            this.connection.setProtocol(this.params.getString("protocol"));
            this.connection.setHost(this.params.getString("host"));
            this.connection.setPort(this.params.getInteger("port"));
            this.connection.setUsername(this.params.getString("user"));
            this.connection.setPassword(this.params.getString("password"));
        }
        System.out.println(String.format("Connecting to system: %s:%d", this.connection.getHost(), this.connection.getPort()));
    }

    private boolean invalidParams(Parameters params) {
        if (!(params.hasValue("connection") || params.hasValue("protocol") && params.hasValue("host") && params.hasValue("port") && params.hasValue("user") && params.hasValue("password"))) {
            return true;
        }
        if (!params.hasValue("update") && !params.hasValue("list")) {
            return true;
        }
        return params.hasValue("list") && !params.hasValue("attributes");
    }

    private void printUsage() {
        System.out.println("Usage:");
        System.out.println("{-connection <properties file> | -protocol {http|https} -host <host> -port <port> -user <username> -password <password>}");
        System.out.println("{  -update <input file> | ");
        System.out.println("   -list <output file> ");
        System.out.println("     [-adapterType <adapter type>]");
        System.out.println("     [-transProtocol <transport protocol>]");
        System.out.println("     [-msgProtocol <message protocol>] ");
        System.out.println("     [-component <component name pattern>] ");
        System.out.println("     [-party <party name pattern>] ");
        System.out.println("     [-channel <channel name pattern>] ");
        System.out.println("     -attributes \"<attribute1 attribute2 ...>\" }");
        System.out.println();
        System.out.println("Connection properties file format:");
        System.out.println("protocol={http|https}");
        System.out.println("host=<host>");
        System.out.println("port=<port>");
        System.out.println("user=<username>");
        System.out.println("password=<password>");
    }
}

