/*
 * Decompiled with CFR 0.152.
 */
package pl.indevo.pi.directory.api.channels;

import com.sap.xi.basis.CommunicationChannel;
import com.sap.xi.basis.CommunicationChannelCreateChangeIn;
import com.sap.xi.basis.CommunicationChannelID;
import com.sap.xi.basis.CommunicationChannelIn;
import com.sap.xi.basis.CommunicationChannelInService;
import com.sap.xi.basis.CommunicationChannelQueryIn;
import com.sap.xi.basis.CommunicationChannelQueryOut;
import com.sap.xi.basis.CommunicationChannelReadIn;
import com.sap.xi.basis.CommunicationChannelReadOut;
import com.sap.xi.basis.ConfigurationObjectModifyOut;
import com.sap.xi.basis.GenericProperty;
import com.sap.xi.basis.GenericPropertyTable;
import com.sap.xi.basis.LogMessageCollection;
import com.sap.xi.basis.LogMessageCommunicationChannel;
import com.sap.xi.basis.ReadContextCode;
import com.sap.xi.basis.RestrictedCommunicationChannel;
import java.io.Console;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.ws.BindingProvider;
import pl.indevo.pi.directory.api.ChangeListService;
import pl.indevo.pi.directory.api.commons.Connection;
import pl.indevo.pi.directory.api.commons.LogSeverity;
import pl.indevo.pi.directory.api.commons.Parameters;
import pl.indevo.pi.directory.api.commons.ProgressBar;

public class CChannelService {
    private ChangeListService changeList = new ChangeListService();
    private Connection connection;
    private Parameters params;
    private String servicePath = "/CommunicationChannelInService/CommunicationChannelInImplBean";
    private CommunicationChannelIn port;
    List<LogMessageCommunicationChannel> messages;

    public void list() throws MalformedURLException, UnsupportedEncodingException, FileNotFoundException {
        List<CommunicationChannelID> channelsIDs;
        int PACKAGE_SIZE = 50;
        ChannelProperties props = new ChannelProperties(this.params);
        CommunicationChannelID channelID = new CommunicationChannelID();
        if (!props.component.isEmpty()) {
            channelID.setComponentID(props.component);
        }
        if (!props.party.isEmpty()) {
            channelID.setPartyID(props.party);
        }
        if (!props.channel.isEmpty()) {
            channelID.setChannelID(props.channel);
        }
        if ((channelsIDs = this.queryAPI(channelID)).isEmpty()) {
            return;
        }
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.params.getString("list")), "UTF-8"));
        this.writeListHeader(writer, props.attributes);
        ProgressBar progress = new ProgressBar(channelsIDs.size());
        while (!channelsIDs.isEmpty()) {
            int sublistSize = channelsIDs.size() >= 50 ? 50 : channelsIDs.size();
            progress.move(sublistSize);
            List<CommunicationChannelID> sublistIDs = channelsIDs.subList(0, sublistSize);
            List<CommunicationChannel> channels = this.readAPI(sublistIDs);
            sublistIDs.clear();
            for (CommunicationChannel channel : channels) {
                if (!props.adapterType.isEmpty() && !channel.getAdapterMetadata().getName().equals(props.adapterType) || !props.transProtocol.isEmpty() && !channel.getTransportProtocol().equals(props.transProtocol) || !props.msgProtocol.isEmpty() && !channel.getMessageProtocol().equals(props.msgProtocol)) continue;
                this.writeChannel(writer, channel, props);
            }
        }
        writer.close();
        progress.complete();
    }

    public void update(List<RestrictedCommunicationChannel> channels) throws MalformedURLException {
        ArrayList<RestrictedCommunicationChannel> createChannels = new ArrayList<RestrictedCommunicationChannel>();
        ArrayList<RestrictedCommunicationChannel> changeChannels = new ArrayList<RestrictedCommunicationChannel>();
        for (RestrictedCommunicationChannel channel : channels) {
            if (this.channelExists(channel.getCommunicationChannelID())) {
                changeChannels.add(channel);
                continue;
            }
            createChannels.add(channel);
        }
        if (createChannels.size() > 0 || changeChannels.size() > 0) {
            String changeListID = this.getChangeListID();
            if (createChannels.size() > 0) {
                System.out.println("Communication Channels to be created:");
                this.printChannelIDs(channels);
                this.createAPI(createChannels, changeListID);
            }
            if (this.hasErrors()) {
                return;
            }
            if (changeChannels.size() > 0) {
                System.out.println("Communication Channels to be changed:");
                this.printChannelIDs(channels);
                this.changeAPI(changeChannels, changeListID);
            }
        }
    }

    private void writeListHeader(PrintWriter writer, String[] attributes) {
        writer.print("Party");
        writer.print("\t");
        writer.print("Component");
        writer.print("\t");
        writer.print("Channel Name");
        writer.print("\t");
        writer.print("Direction");
        writer.print("\t");
        writer.print("Description");
        writer.print("\t");
        writer.print("Adapter Type");
        writer.print("\t");
        writer.print("Adapter Namespace");
        writer.print("\t");
        writer.print("Adapter SWCV");
        writer.print("\t");
        writer.print("Tran. Prot.");
        writer.print("\t");
        writer.print("Tran. Prot. Ver.");
        writer.print("\t");
        writer.print("Msg. Prot.");
        writer.print("\t");
        writer.print("Msg. Prot. Ver.");
        writer.print("\t");
        writer.print("Adapter Attributes");
        int i = 0;
        while (i < attributes.length) {
            writer.print("\t");
            writer.print(attributes[i]);
            ++i;
        }
        writer.println();
    }

    private void writeChannel(PrintWriter writer, CommunicationChannel channel, ChannelProperties props) {
        CommunicationChannelID channelID = new CommunicationChannelID();
        channelID = channel.getCommunicationChannelID();
        writer.print(channelID.getPartyID());
        writer.print("\t");
        writer.print(channelID.getComponentID());
        writer.print("\t");
        writer.print(channelID.getChannelID());
        writer.print("\t");
        writer.print(channel.getDirection().name());
        writer.print("\t");
        if (!channel.getDescription().isEmpty()) {
            writer.print(this.replaceTabs(channel.getDescription().get(0).getValue()));
        }
        writer.print("\t");
        writer.print(channel.getAdapterMetadata().getName());
        writer.print("\t");
        writer.print(channel.getAdapterMetadata().getNamespace());
        writer.print("\t");
        writer.print(channel.getAdapterMetadata().getSoftwareComponentVersionID());
        writer.print("\t");
        writer.print(channel.getTransportProtocol());
        writer.print("\t");
        writer.print(channel.getTransportProtocolVersion());
        writer.print("\t");
        writer.print(channel.getMessageProtocol());
        writer.print("\t");
        writer.print(channel.getMessageProtocolVersion());
        writer.print("\t");
        writer.print("\t");
        this.writeAdapterAttributes(writer, channel, props.attributes);
        writer.println();
    }

    private void writeAdapterAttributes(PrintWriter writer, CommunicationChannel channel, String[] attributes) {
        List<GenericProperty> attrs = channel.getAdapterSpecificAttribute();
        int i = 0;
        while (i < attributes.length) {
            boolean attributeFound = false;
            int j = 0;
            while (j < attrs.size()) {
                if (attributes[i].equals(attrs.get(j).getName())) {
                    attributeFound = true;
                    writer.print(attrs.get(j).getValue());
                    writer.print("\t");
                    break;
                }
                ++j;
            }
            if (!attributeFound) {
                writer.print("n/a\t");
            }
            ++i;
        }
    }

    private List<CommunicationChannelID> queryAPI(CommunicationChannelID channelID) {
        CommunicationChannelQueryIn query = new CommunicationChannelQueryIn();
        query.setCommunicationChannelID(channelID);
        try {
            CommunicationChannelQueryOut result = this.getServicePort().query(query);
            List<CommunicationChannelID> channelsIDs = result.getCommunicationChannelID();
            if (channelsIDs.size() == 0) {
                System.out.println("No channels have been found for the specified criteria");
            }
            return channelsIDs;
        }
        catch (Exception e) {
            System.out.println("Directory API cannot be reached: " + e.getMessage());
            return new ArrayList<CommunicationChannelID>();
        }
    }

    private void createAPI(List<RestrictedCommunicationChannel> channels, String changeListID) throws MalformedURLException {
        CommunicationChannelCreateChangeIn request = new CommunicationChannelCreateChangeIn();
        request.setChangeListID(changeListID);
        request.getCommunicationChannel().addAll(channels);
        try {
            ConfigurationObjectModifyOut result = this.getServicePort().create(request);
            LogMessageCollection log = result.getLogMessageCollection();
            this.messages = log.getLogMessageCommunicationChannel();
            this.printMessages();
            if (this.hasErrors()) {
                System.err.println("Please check the errors");
                this.rejectChanges(changeListID);
            }
        }
        catch (Exception e) {
            System.err.println("Directory API cannot be reached: " + e.getMessage());
            this.rejectChanges(changeListID);
        }
    }

    private void changeAPI(List<RestrictedCommunicationChannel> channels, String changeListID) throws MalformedURLException {
        this.mergeCurrentData(channels);
        CommunicationChannelCreateChangeIn request = new CommunicationChannelCreateChangeIn();
        request.setChangeListID(changeListID);
        request.getCommunicationChannel().addAll(channels);
        try {
            ConfigurationObjectModifyOut result = this.getServicePort().change(request);
            LogMessageCollection log = result.getLogMessageCollection();
            this.messages = log.getLogMessageCommunicationChannel();
            this.printMessages();
            if (this.hasErrors()) {
                System.out.println("Please check the errors");
                this.rejectChanges(changeListID);
            }
        }
        catch (Exception e) {
            System.err.println("Directory API cannot be reached: " + e.getMessage());
            this.rejectChanges(changeListID);
        }
    }

    public boolean channelExists(CommunicationChannelID channelID) throws MalformedURLException {
        CommunicationChannelQueryIn query = new CommunicationChannelQueryIn();
        query.setCommunicationChannelID(channelID);
        CommunicationChannelQueryOut result = this.getServicePort().query(query);
        return result.getCommunicationChannelID().size() != 0;
    }

    private List<CommunicationChannel> readAPI(List<CommunicationChannelID> channelIDs) throws MalformedURLException {
        CommunicationChannelReadIn request = new CommunicationChannelReadIn();
        request.setReadContext(ReadContextCode.USER);
        request.getCommunicationChannelID().addAll(channelIDs);
        CommunicationChannelReadOut result = this.getServicePort().read(request);
        LogMessageCollection log = result.getLogMessageCollection();
        this.messages = log.getLogMessageCommunicationChannel();
        this.printMessages();
        return result.getCommunicationChannel();
    }

    private void mergeCurrentData(List<RestrictedCommunicationChannel> channels) throws MalformedURLException {
        List<CommunicationChannel> currentChannels = this.readAPI(this.getChannelIDs(channels));
        int i = 0;
        while (i < channels.size()) {
            this.mergeData(channels.get(i), currentChannels.get(i));
            ++i;
        }
    }

    private void mergeData(RestrictedCommunicationChannel channel, CommunicationChannel currentChannel) {
        HashSet<String> newAttrsSet = new HashSet<String>();
        channel.setModuleProcess(currentChannel.getModuleProcess());
        if (channel.getDescription().isEmpty()) {
            channel.getDescription().addAll(currentChannel.getDescription());
        }
        List<GenericProperty> newAttrs = channel.getAdapterSpecificAttribute();
        int i = 0;
        while (i < newAttrs.size()) {
            newAttrsSet.add(newAttrs.get(i).getName());
            ++i;
        }
        List<GenericProperty> currAttrs = currentChannel.getAdapterSpecificAttribute();
        int i2 = 0;
        while (i2 < currAttrs.size()) {
            if (!newAttrsSet.contains(currAttrs.get(i2).getName())) {
                newAttrs.add(currAttrs.get(i2));
            }
            ++i2;
        }
        List<GenericPropertyTable> curAttrsTab = currentChannel.getAdapterSpecificTableAttribute();
        channel.getAdapterSpecificTableAttribute().addAll(curAttrsTab);
    }

    private void printChannelIDs(List<RestrictedCommunicationChannel> channels) {
        for (RestrictedCommunicationChannel channel : channels) {
            this.printChannelID(channel.getCommunicationChannelID());
            System.out.println();
        }
    }

    private void printChannelID(CommunicationChannelID channelID) {
        if (channelID == null) {
            return;
        }
        System.out.print("|");
        if (channelID.getPartyID() != null) {
            System.out.print(channelID.getPartyID());
        }
        System.out.print("|");
        System.out.print(channelID.getComponentID());
        System.out.print("|");
        System.out.print(channelID.getChannelID());
        System.out.print("|");
    }

    private List<CommunicationChannelID> getChannelIDs(List<RestrictedCommunicationChannel> channels) {
        ArrayList<CommunicationChannelID> channelIDs = new ArrayList<CommunicationChannelID>();
        for (RestrictedCommunicationChannel channel : channels) {
            channelIDs.add(channel.getCommunicationChannelID());
        }
        return channelIDs;
    }

    private String getChangeListID() throws MalformedURLException {
        String answer = "n";
        Console console = System.console();
        if (console != null) {
            answer = console.readLine("Would you like to reuse an existing Change List (y/n)? ", new Object[0]);
        }
        if (answer.equalsIgnoreCase("y")) {
            return System.console().readLine("Pleae enter your Change List ID? ", new Object[0]);
        }
        return this.changeList.createChangeList("INDEVO.PL - CC Mass Update");
    }

    private CommunicationChannelIn getServicePort() throws MalformedURLException {
        if (this.port == null) {
            CommunicationChannelInService ws = new CommunicationChannelInService();
            this.port = ws.getCommunicationChannelInPort();
            BindingProvider bp = (BindingProvider)this.port;
            bp.getRequestContext().put("javax.xml.ws.security.auth.username", this.connection.getUsername());
            bp.getRequestContext().put("javax.xml.ws.security.auth.password", this.connection.getPassword());
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.connection.getUrlPath(this.servicePath));
        }
        return this.port;
    }

    public boolean hasErrors() {
        if (this.messages == null) {
            return false;
        }
        for (LogMessageCommunicationChannel message : this.messages) {
            if (!LogSeverity.Error.equals(message.getLogMessageItem().getSeverityCode())) continue;
            return true;
        }
        return false;
    }

    private void printMessages() {
        if (this.messages == null || this.messages.size() == 0) {
            return;
        }
        System.out.println("Messages:");
        for (LogMessageCommunicationChannel message : this.messages) {
            System.out.print(this.severity(message.getLogMessageItem().getSeverityCode()));
            System.out.print(" : ");
            this.printChannelID(message.getCommunicationChannelID());
            System.out.print(" : ");
            System.out.println(message.getLogMessageItem().getMessage().getValue());
        }
    }

    private String severity(String code) {
        if (code.equals("1")) {
            return "INFORMATION";
        }
        if (code.equals("2")) {
            return "WARNING";
        }
        if (code.equals("3")) {
            return "ERROR";
        }
        if (code.equals("4")) {
            return "TERMINATION";
        }
        return "OTHER";
    }

    private String replaceTabs(String value) {
        return value.replace('\t', ' ');
    }

    private void rejectChanges(String changeListID) throws MalformedURLException {
        System.out.println("Rejecting changes...");
        this.changeList.reject(changeListID);
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.changeList.setConnection(connection);
    }

    public void setParameters(Parameters params) {
        this.params = params;
    }

    class ChannelProperties {
        String[] attributes;
        String adapterType;
        String transProtocol;
        String msgProtocol;
        String component;
        String party;
        String channel;

        ChannelProperties(Parameters params) {
            this.attributes = params.getString("attributes").split(" ");
            this.adapterType = params.getString("adapterType");
            this.transProtocol = params.getString("transProtocol");
            this.msgProtocol = params.getString("msgProtocol");
            this.component = params.getString("component");
            this.party = params.getString("party");
            this.channel = params.getString("channelName");
        }
    }
}

