/*
 * Decompiled with CFR 0.152.
 */
package pl.indevo.pi.directory.api.channels;

import com.sap.xi.basis.CommunicationChannelDirection;
import com.sap.xi.basis.CommunicationChannelID;
import com.sap.xi.basis.DesignObjectID;
import com.sap.xi.basis.GenericProperty;
import com.sap.xi.basis.RestrictedCommunicationChannel;
import com.sap.xi.basis.global.LONGDescription;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CChannelFile {
    private String[] header;
    private String[] attributes;
    private Map<String, String> attributesMap = new HashMap<String, String>();

    public List<RestrictedCommunicationChannel> parse(String fileName) throws IOException {
        ArrayList<RestrictedCommunicationChannel> channels = new ArrayList<RestrictedCommunicationChannel>();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
        String line = reader.readLine();
        this.header = line.split("\t");
        while ((line = reader.readLine()) != null) {
            this.attributes = line.split("\t");
            this.buildAttributesMap();
            RestrictedCommunicationChannel channel = new RestrictedCommunicationChannel();
            channel.setMasterLanguage("EN");
            this.setChannelID(channel);
            this.setAdapterMetadata(channel);
            this.setDirection(channel);
            this.setDescription(channel);
            this.setProtocols(channel);
            this.setAdapterSpecificAttributes(channel);
            channels.add(channel);
        }
        reader.close();
        return channels;
    }

    private void buildAttributesMap() {
        this.attributesMap.clear();
        int i = 0;
        while (i < this.header.length) {
            if (i < this.attributes.length) {
                this.attributesMap.put(this.header[i], this.attributes[i]);
            }
            ++i;
        }
    }

    private void setChannelID(RestrictedCommunicationChannel channel) {
        CommunicationChannelID channelID = new CommunicationChannelID();
        channelID.setPartyID(this.attributesMap.get("Party"));
        channelID.setComponentID(this.attributesMap.get("Component"));
        channelID.setChannelID(this.attributesMap.get("Channel Name"));
        channel.setCommunicationChannelID(channelID);
    }

    private void setAdapterMetadata(RestrictedCommunicationChannel channel) {
        DesignObjectID metadata = new DesignObjectID();
        metadata.setName(this.attributesMap.get("Adapter Type"));
        metadata.setNamespace(this.attributesMap.get("Adapter Namespace"));
        metadata.setSoftwareComponentVersionID(this.attributesMap.get("Adapter SWCV"));
        channel.setAdapterMetadata(metadata);
    }

    private void setDirection(RestrictedCommunicationChannel channel) {
        if ("SENDER".equalsIgnoreCase(this.attributesMap.get("Direction"))) {
            channel.setDirection(CommunicationChannelDirection.SENDER);
        } else {
            channel.setDirection(CommunicationChannelDirection.RECEIVER);
        }
    }

    private void setDescription(RestrictedCommunicationChannel channel) {
        if (this.attributesMap.containsKey("Description") && this.attributesMap.get("Description").length() > 0) {
            LONGDescription description = new LONGDescription();
            description.setLanguageCode("EN");
            description.setValue(this.attributesMap.get("Description"));
            channel.getDescription().add(description);
        }
    }

    private void setProtocols(RestrictedCommunicationChannel channel) {
        channel.setTransportProtocol(this.attributesMap.get("Tran. Prot."));
        channel.setTransportProtocolVersion(this.attributesMap.get("Tran. Prot. Ver."));
        channel.setMessageProtocol(this.attributesMap.get("Msg. Prot."));
        channel.setMessageProtocolVersion(this.attributesMap.get("Msg. Prot. Ver."));
    }

    private void setAdapterSpecificAttributes(RestrictedCommunicationChannel channel) {
        channel.getAdapterSpecificAttribute().clear();
        int attrStart = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.header.length) {
            if (this.header[i].equals("Adapter Attributes")) {
                attrStart = i + 1;
            }
            ++i;
        }
        i = attrStart;
        while (i < this.attributes.length) {
            if (this.attributes[i] != null && this.attributes[i].length() > 0 && !this.attributes[i].equalsIgnoreCase("n/a")) {
                GenericProperty attribute = new GenericProperty();
                attribute.setName(this.header[i]);
                attribute.setValue(this.attributes[i]);
                channel.getAdapterSpecificAttribute().add(attribute);
            }
            ++i;
        }
    }
}

