/*
 * Decompiled with CFR 0.152.
 */
package pl.indevo.pi.directory.api.ico;

import com.sap.xi.basis.CommunicationChannelID;
import com.sap.xi.basis.CommunicationComponentID;
import com.sap.xi.basis.Condition;
import com.sap.xi.basis.ConfigurationObjectModifyOut;
import com.sap.xi.basis.DesignObjectID;
import com.sap.xi.basis.InboundProcessing;
import com.sap.xi.basis.IntegratedConfiguration;
import com.sap.xi.basis.IntegratedConfigurationCreateChangeIn;
import com.sap.xi.basis.IntegratedConfigurationIn;
import com.sap.xi.basis.IntegratedConfigurationInService;
import com.sap.xi.basis.IntegratedConfigurationReadIn;
import com.sap.xi.basis.IntegratedConfigurationReadOut;
import com.sap.xi.basis.IntegratedConfigurationReceiverInterfaceRule;
import com.sap.xi.basis.IntegratedConfigurationReceiverRule;
import com.sap.xi.basis.LogMessageCollection;
import com.sap.xi.basis.LogMessageMessageHeader;
import com.sap.xi.basis.MessageHeaderID;
import com.sap.xi.basis.NoReceiverBehaviour;
import com.sap.xi.basis.OutboundProcessing;
import com.sap.xi.basis.QualityOfService;
import com.sap.xi.basis.ReceiverInterfaces;
import com.sap.xi.basis.Receivers;
import com.sap.xi.basis.RestrictedIntegratedConfiguration;
import com.sap.xi.basis.global.LONGDescription;
import java.io.BufferedReader;
import java.io.Console;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.ws.BindingProvider;
import pl.indevo.pi.directory.api.ChangeListService;
import pl.indevo.pi.directory.api.commons.Connection;
import pl.indevo.pi.directory.api.commons.LogSeverity;
import pl.indevo.pi.directory.api.commons.Parameters;
import pl.indevo.pi.directory.api.ico.ConditionParser;
import pl.indevo.pi.directory.api.ico.ConditionSerializer;
import pl.indevo.pi.directory.api.ico.InvalidFormatException;

public class ICOService {
    private ChangeListService changeList = new ChangeListService();
    private static final String ICO_HEADER = "ICO Definition File (indevo.pl)";
    private Connection connection;
    private Parameters params;
    private String servicePath = "/IntegratedConfigurationInService/IntegratedConfigurationInImplBean";
    private IntegratedConfigurationIn port;
    private ConditionParser condParser = new ConditionParser();

    public void serialize() throws MalformedURLException, FileNotFoundException, UnsupportedEncodingException {
        MessageHeaderID icoID = new MessageHeaderID();
        icoID.setSenderPartyID(this.params.getString("senderParty"));
        icoID.setSenderComponentID(this.params.getString("senderComponent"));
        icoID.setInterfaceName(this.params.getString("interfaceName"));
        icoID.setInterfaceNamespace(this.params.getString("interfaceNS"));
        IntegratedConfiguration ico = this.readAPISingle(icoID);
        if (ico != null) {
            this.writeIcoFile(ico);
            this.writeReceiversFile(ico);
            this.writeInterfacesFile(ico);
            this.writeChannelsFile(ico);
        }
    }

    public void update() throws IOException, InvalidFormatException {
        RestrictedIntegratedConfiguration icoNew;
        RestrictedIntegratedConfiguration icoFile = this.loadICO(this.params.getString("update"));
        MessageHeaderID icoID = icoFile.getIntegratedConfigurationID();
        if ("append".equals(this.params.getString("mode"))) {
            IntegratedConfiguration icoSystem = this.readAPISingle(icoID);
            icoNew = this.append(icoSystem, icoFile);
        } else {
            icoNew = icoFile;
        }
        String changeListID = this.getChangeListID();
        System.out.printf("Updating ICO: %s", this.icoIDText(icoID));
        System.out.println();
        IntegratedConfigurationCreateChangeIn request = new IntegratedConfigurationCreateChangeIn();
        request.getIntegratedConfiguration().add(icoNew);
        request.setChangeListID(changeListID);
        try {
            ConfigurationObjectModifyOut result = this.getServicePort().change(request);
            LogMessageCollection log = result.getLogMessageCollection();
            List<LogMessageMessageHeader> messages = log.getLogMessageIntegratedConfiguration();
            this.printMessages(messages);
            if (this.hasErrors(messages)) {
                System.out.println("Please check the errors");
                this.rejectChanges(changeListID);
            }
        }
        catch (Exception e) {
            System.err.println("Directory API cannot be reached: " + e.getMessage());
            this.rejectChanges(changeListID);
            return;
        }
    }

    RestrictedIntegratedConfiguration append(IntegratedConfiguration icoSystem, RestrictedIntegratedConfiguration icoFile) {
        RestrictedIntegratedConfiguration merged = new RestrictedIntegratedConfiguration();
        merged.setIntegratedConfigurationID(icoSystem.getIntegratedConfigurationID());
        merged.setLogging(icoSystem.getLogging());
        merged.setMasterLanguage(icoSystem.getMasterLanguage());
        if (icoSystem.getDescription().size() > 0) {
            merged.getDescription().addAll(icoSystem.getDescription());
        }
        merged.setStaging(icoSystem.getStaging());
        merged.setInboundProcessing(icoSystem.getInboundProcessing());
        merged.setReceivers(icoSystem.getReceivers());
        merged.getReceivers().getReceiverRule().addAll(icoFile.getReceivers().getReceiverRule());
        merged.getReceiverInterfaces().addAll(icoSystem.getReceiverInterfaces());
        merged.getReceiverInterfaces().addAll(icoFile.getReceiverInterfaces());
        merged.getOutboundProcessing().addAll(icoSystem.getOutboundProcessing());
        merged.getOutboundProcessing().addAll(icoFile.getOutboundProcessing());
        return merged;
    }

    private IntegratedConfiguration readAPISingle(MessageHeaderID icoID) {
        IntegratedConfigurationReadOut result;
        System.out.printf("Reading ICO: %s", this.icoIDText(icoID));
        System.out.println();
        IntegratedConfigurationReadIn icoReadRequest = new IntegratedConfigurationReadIn();
        icoReadRequest.getIntegratedConfigurationID().add(icoID);
        try {
            result = this.getServicePort().read(icoReadRequest);
        }
        catch (Exception e) {
            System.out.println("Directory API cannot be reached: " + e.getMessage());
            return null;
        }
        if (result.getIntegratedConfiguration().size() == 0) {
            System.out.println("No Integrated Configuration found for the specified parameters");
            return null;
        }
        return result.getIntegratedConfiguration().get(0);
    }

    private void writeIcoFile(IntegratedConfiguration ico) throws FileNotFoundException, UnsupportedEncodingException {
        System.out.printf("%-30s: %s", "Writing ICO to file: ", this.getICOFileName());
        System.out.println();
        PrintWriter writer = this.getWriter(this.getICOFileName());
        writer.println(ICO_HEADER);
        writer.println("SenderParty=" + ico.getIntegratedConfigurationID().getSenderPartyID());
        writer.println("SenderComponent=" + ico.getIntegratedConfigurationID().getSenderComponentID());
        writer.println("SenderChannel=" + this.getChannelID(ico.getInboundProcessing().getCommunicationChannel()));
        writer.println("InterfaceName=" + ico.getIntegratedConfigurationID().getInterfaceName());
        writer.println("InterfaceNS=" + ico.getIntegratedConfigurationID().getInterfaceNamespace());
        writer.println("InterfaceSWCV=" + this.defaultValue(ico.getInboundProcessing().getSenderInterfaceSoftwareComponentVersion(), ""));
        writer.println("ReceiverParty=" + ico.getIntegratedConfigurationID().getReceiverPartyID());
        writer.println("ReceiverComponent=" + ico.getIntegratedConfigurationID().getReceiverComponentID());
        writer.println("MasterLanguage=" + ico.getMasterLanguage());
        writer.println("Description=" + this.icoDescription(ico, ico.getMasterLanguage()));
        writer.println("NoReceiverBehaviour=" + (Object)((Object)ico.getReceivers().getNoReceiverBehaviour()));
        writer.println("ReceiversFile=" + this.getFileName("_Receivers"));
        writer.println("InterfacesFile=" + this.getFileName("_Interfaces"));
        writer.println("ChannelsFile=" + this.getFileName("_Channels"));
        writer.close();
    }

    private void writeReceiversFile(IntegratedConfiguration ico) throws FileNotFoundException, UnsupportedEncodingException {
        System.out.printf("%-30s: %s", "Writing Receivers to file: ", this.getFileName("_Receivers"));
        System.out.println();
        PrintWriter writer = this.getWriter(this.getFileName("_Receivers"));
        List<IntegratedConfigurationReceiverRule> receiverRules = ico.getReceivers().getReceiverRule();
        writer.println("ReceiverParty\tReceiverComponent\tCondition");
        for (IntegratedConfigurationReceiverRule rule : receiverRules) {
            List<CommunicationComponentID> receivers = rule.getReceiver();
            for (CommunicationComponentID receiver : receivers) {
                writer.print(receiver.getPartyID());
                writer.print("\t");
                writer.print(receiver.getComponentID());
                writer.print("\t");
                Condition cond = rule.getCondition();
                if (cond != null) {
                    writer.print(ConditionSerializer.toString(cond));
                }
                writer.println();
            }
        }
        writer.close();
    }

    private void writeInterfacesFile(IntegratedConfiguration ico) throws FileNotFoundException, UnsupportedEncodingException {
        System.out.printf("%-30s: %s", "Writing Interfaces to file: ", this.getFileName("_Interfaces"));
        System.out.println();
        PrintWriter writer = this.getWriter(this.getFileName("_Interfaces"));
        List<ReceiverInterfaces> interfaces = ico.getReceiverInterfaces();
        writer.println("ReceiverParty\tReceiverComponent\tCondition\tMappingName\tMappingNS\tMappingSWCV\tInterafceName\tInterfaceNS\tInterfaceSWCV\tQoS");
        for (ReceiverInterfaces intf : interfaces) {
            List<IntegratedConfigurationReceiverInterfaceRule> rules = intf.getReceiverInterfaceRule();
            for (IntegratedConfigurationReceiverInterfaceRule rule : rules) {
                writer.print(intf.getReceiver().getPartyID());
                writer.print("\t");
                writer.print(intf.getReceiver().getComponentID());
                writer.print("\t");
                Condition cond = rule.getCondition();
                if (cond != null) {
                    writer.print(ConditionSerializer.toString(cond));
                }
                writer.print("\t");
                DesignObjectID mapping = rule.getMapping();
                if (mapping != null) {
                    writer.print(rule.getMapping().getName());
                    writer.print("\t");
                    writer.print(rule.getMapping().getNamespace());
                    writer.print("\t");
                    writer.print(rule.getMapping().getSoftwareComponentVersionID());
                    writer.print("\t");
                } else {
                    writer.print("\t\t\t");
                }
                this.writeInterface(writer, rule.getInterface().get(0));
                writer.print("\t");
                writer.print(intf.getQualityOfService().value());
                writer.println();
            }
        }
        writer.close();
    }

    private void writeChannelsFile(IntegratedConfiguration ico) throws FileNotFoundException, UnsupportedEncodingException {
        System.out.printf("%-30s: %s", "Writing Channels to file", this.getFileName("_Channels"));
        System.out.println();
        PrintWriter writer = this.getWriter(this.getFileName("_Channels"));
        writer.println("ReceiverParty\tReceiverComponent\tInterfaceName\tInterfaceNS\tInterfaceSWCV\tChannelParty\tChannelComponent\tChannelName");
        List<OutboundProcessing> channels = ico.getOutboundProcessing();
        for (OutboundProcessing channel : channels) {
            writer.print(channel.getReceiver().getPartyID());
            writer.print("\t");
            writer.print(channel.getReceiver().getComponentID());
            writer.print("\t");
            writer.print(channel.getReceiverInterface().getName());
            writer.print("\t");
            writer.print(channel.getReceiverInterface().getNamespace());
            writer.print("\t");
            writer.print(channel.getReceiverInterface().getSoftwareComponentVersionID());
            writer.print("\t");
            writer.print(channel.getCommunicationChannel().getPartyID());
            writer.print("\t");
            writer.print(channel.getCommunicationChannel().getComponentID());
            writer.print("\t");
            writer.print(channel.getCommunicationChannel().getChannelID());
            writer.println();
        }
        writer.close();
    }

    private void writeInterface(PrintWriter writer, DesignObjectID intf) {
        writer.print(intf.getName());
        writer.print("\t");
        writer.print(intf.getNamespace());
        writer.print("\t");
        writer.print(intf.getSoftwareComponentVersionID());
    }

    private String getChangeListID() throws MalformedURLException {
        String answer = "n";
        Console console = System.console();
        if (console != null) {
            answer = console.readLine("Would you like to reuse an existing Change List (y/n)? ", new Object[0]);
        }
        if (answer.equalsIgnoreCase("y")) {
            return System.console().readLine("Pleae enter your Change List ID? ", new Object[0]);
        }
        return this.changeList.createChangeList("INDEVO.PL - ICO Mass Update");
    }

    private IntegratedConfigurationIn getServicePort() throws MalformedURLException {
        if (this.port == null) {
            IntegratedConfigurationInService ws = new IntegratedConfigurationInService();
            this.port = ws.getIntegratedConfigurationInPort();
            BindingProvider bp = (BindingProvider)this.port;
            bp.getRequestContext().put("javax.xml.ws.security.auth.username", this.connection.getUsername());
            bp.getRequestContext().put("javax.xml.ws.security.auth.password", this.connection.getPassword());
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.connection.getUrlPath(this.servicePath));
        }
        return this.port;
    }

    private void rejectChanges(String changeListID) throws MalformedURLException {
        System.out.println("Rejecting changes...");
        this.changeList.reject(changeListID);
    }

    private RestrictedIntegratedConfiguration loadICO(String filepath) throws IOException, InvalidFormatException {
        Properties icoDef = new Properties();
        icoDef.load(new FileInputStream(filepath));
        RestrictedIntegratedConfiguration newICO = new RestrictedIntegratedConfiguration();
        newICO.setMasterLanguage(icoDef.getProperty("MasterLanguage"));
        newICO.getDescription().add(this.createDescription(icoDef.getProperty("Description"), icoDef.getProperty("MasterLanguage")));
        MessageHeaderID icoID = new MessageHeaderID();
        icoID.setSenderPartyID(icoDef.getProperty("SenderParty"));
        icoID.setSenderComponentID(icoDef.getProperty("SenderComponent"));
        icoID.setInterfaceName(icoDef.getProperty("InterfaceName"));
        icoID.setInterfaceNamespace(icoDef.getProperty("InterfaceNS"));
        icoID.setReceiverPartyID(icoDef.getProperty("ReceiverParty"));
        icoID.setReceiverComponentID(icoDef.getProperty("ReceiverComponent"));
        newICO.setIntegratedConfigurationID(icoID);
        InboundProcessing inbound = new InboundProcessing();
        inbound.setCommunicationChannel(this.channelIDFromString(icoDef.getProperty("SenderChannel")));
        inbound.setSenderInterfaceSoftwareComponentVersion(icoDef.getProperty("InterfaceSWCV"));
        newICO.setInboundProcessing(inbound);
        Receivers receivers = this.loadICOReceivers(icoDef.getProperty("ReceiversFile"));
        receivers.setNoReceiverBehaviour(NoReceiverBehaviour.valueOf(icoDef.getProperty("NoReceiverBehaviour")));
        newICO.setReceivers(receivers);
        newICO.getReceiverInterfaces().addAll(this.loadICOInterfaces(icoDef.getProperty("InterfacesFile")));
        newICO.getOutboundProcessing().addAll(this.loadICOChannels(icoDef.getProperty("ChannelsFile")));
        return newICO;
    }

    private Receivers loadICOReceivers(String filepath) throws IOException, InvalidFormatException {
        String line;
        Receivers receivers = new Receivers();
        BufferedReader reader = new BufferedReader(new FileReader(filepath));
        reader.readLine();
        int i = 1;
        while ((line = reader.readLine()) != null) {
            ++i;
            String[] fields = line.split("\t", -1);
            if (fields.length != 3) {
                throw new InvalidFormatException(String.format("%s:%d line is invalid (not 3 fields)", filepath, i));
            }
            IntegratedConfigurationReceiverRule rule = new IntegratedConfigurationReceiverRule();
            CommunicationComponentID receiver = new CommunicationComponentID();
            receiver.setPartyID(fields[0]);
            receiver.setComponentID(fields[1]);
            rule.getReceiver().add(receiver);
            Condition condition = this.condParser.parseExpression(fields[2]);
            rule.setCondition(condition);
            receivers.getReceiverRule().add(rule);
        }
        return receivers;
    }

    private List<ReceiverInterfaces> loadICOInterfaces(String filepath) throws IOException, InvalidFormatException {
        String line;
        ArrayList<ReceiverInterfaces> receivers = new ArrayList<ReceiverInterfaces>();
        BufferedReader reader = new BufferedReader(new FileReader(filepath));
        reader.readLine();
        CommunicationComponentID receiver = null;
        ReceiverInterfaces receiverIntf = null;
        int i = 1;
        while ((line = reader.readLine()) != null) {
            ++i;
            String[] fields = line.split("\t", -1);
            if (fields.length != 10) {
                throw new InvalidFormatException(String.format("%s:%d line is invalid (not 10 fields)", filepath, i));
            }
            if (receiver == null || !receiver.getPartyID().equals(fields[0]) || !receiver.getComponentID().equals(fields[1])) {
                receiverIntf = new ReceiverInterfaces();
                receivers.add(receiverIntf);
            }
            receiver = new CommunicationComponentID();
            receiver.setPartyID(fields[0]);
            receiver.setComponentID(fields[1]);
            receiverIntf.setReceiver(receiver);
            IntegratedConfigurationReceiverInterfaceRule rule = new IntegratedConfigurationReceiverInterfaceRule();
            Condition condition = this.condParser.parseExpression(fields[2]);
            rule.setCondition(condition);
            if (!fields[3].isEmpty()) {
                DesignObjectID mapping = new DesignObjectID();
                mapping.setName(fields[3]);
                mapping.setNamespace(fields[4]);
                mapping.setSoftwareComponentVersionID(fields[5]);
                rule.setMapping(mapping);
            }
            DesignObjectID intf = new DesignObjectID();
            intf.setName(fields[6]);
            intf.setNamespace(fields[7]);
            intf.setSoftwareComponentVersionID(fields[8]);
            rule.getInterface().add(intf);
            receiverIntf.setQualityOfService(QualityOfService.valueOf(fields[9]));
            receiverIntf.getReceiverInterfaceRule().add(rule);
        }
        if (receiverIntf != null) {
            receivers.add(receiverIntf);
        }
        return receivers;
    }

    private List<OutboundProcessing> loadICOChannels(String filepath) throws IOException {
        String line;
        ArrayList<OutboundProcessing> channels = new ArrayList<OutboundProcessing>();
        BufferedReader reader = new BufferedReader(new FileReader(filepath));
        reader.readLine();
        int i = 1;
        while ((line = reader.readLine()) != null) {
            ++i;
            String[] fields = line.split("\t", -1);
            if (fields.length != 8) {
                throw new InvalidFormatException(String.format("%s:%d line is invalid (not 8 fields)", filepath, i));
            }
            OutboundProcessing channel = new OutboundProcessing();
            CommunicationComponentID receiver = new CommunicationComponentID();
            receiver.setPartyID(fields[0]);
            receiver.setComponentID(fields[1]);
            channel.setReceiver(receiver);
            DesignObjectID intf = new DesignObjectID();
            intf.setName(fields[2]);
            intf.setNamespace(fields[3]);
            intf.setSoftwareComponentVersionID(fields[4]);
            channel.setReceiverInterface(intf);
            CommunicationChannelID channelID = new CommunicationChannelID();
            channelID.setPartyID(fields[5]);
            channelID.setComponentID(fields[6]);
            channelID.setChannelID(fields[7]);
            channel.setCommunicationChannel(channelID);
            channels.add(channel);
        }
        return channels;
    }

    private String icoDescription(IntegratedConfiguration ico, String language) {
        if (ico.getDescription() != null && ico.getDescription().size() == 0) {
            return "";
        }
        for (LONGDescription descr : ico.getDescription()) {
            if (!descr.getLanguageCode().equals(language)) continue;
            return descr.getValue();
        }
        return "";
    }

    private LONGDescription createDescription(String description, String language) {
        LONGDescription descr = new LONGDescription();
        descr.setLanguageCode(language);
        descr.setValue(description);
        return descr;
    }

    private String getChannelID(CommunicationChannelID id) {
        return String.format("%s|%s|%s", id.getPartyID(), id.getComponentID(), id.getChannelID());
    }

    private CommunicationChannelID channelIDFromString(String value) throws InvalidFormatException {
        String[] fields = value.split("[|]", -1);
        if (fields.length != 3) {
            throw new InvalidFormatException("Invalid Communication Channel format: " + value);
        }
        CommunicationChannelID id = new CommunicationChannelID();
        id.setPartyID(fields[0]);
        id.setComponentID(fields[1]);
        id.setChannelID(fields[2]);
        return id;
    }

    private PrintWriter getWriter(String filepath) throws FileNotFoundException, UnsupportedEncodingException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filepath), "UTF-8"));
    }

    private String getICOFileName() {
        return this.params.getString("read");
    }

    private String getFilePrefix() {
        String filename = this.getICOFileName();
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            return filename.substring(0, i);
        }
        return filename;
    }

    private String getFileExt() {
        String ext = "";
        String filename = this.getICOFileName();
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            ext = filename.substring(i);
        }
        return ext;
    }

    private String getFileName(String suffix) {
        return String.valueOf(this.getFilePrefix()) + suffix + this.getFileExt();
    }

    public boolean hasErrors(List<LogMessageMessageHeader> messages) {
        if (messages == null) {
            return false;
        }
        for (LogMessageMessageHeader message : messages) {
            if (!LogSeverity.Error.equals(message.getLogMessageItem().getSeverityCode())) continue;
            return true;
        }
        return false;
    }

    private void printMessages(List<LogMessageMessageHeader> messages) {
        if (messages == null || messages.size() == 0) {
            return;
        }
        System.out.println("Messages:");
        for (LogMessageMessageHeader message : messages) {
            System.out.print(this.severity(message.getLogMessageItem().getSeverityCode()));
            System.out.print(" : ");
            System.out.println(message.getLogMessageItem().getMessage().getValue());
        }
    }

    private String severity(String code) {
        if (code.equals("1")) {
            return "INFORMATION";
        }
        if (code.equals("2")) {
            return "WARNING";
        }
        if (code.equals("3")) {
            return "ERROR";
        }
        if (code.equals("4")) {
            return "TERMINATION";
        }
        return "OTHER";
    }

    private String defaultValue(String value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.changeList.setConnection(connection);
    }

    public void setParameters(Parameters params) {
        this.params = params;
    }

    private String icoIDText(MessageHeaderID icoID) {
        return String.format("%s|%s|%s|", icoID.getSenderPartyID(), icoID.getSenderComponentID(), icoID.getInterfaceName());
    }
}

