/*
 * Decompiled with CFR 0.152.
 */
package pl.indevo.pi.directory.api.ico;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Properties;
import pl.indevo.pi.directory.api.commons.Connection;
import pl.indevo.pi.directory.api.commons.Parameters;
import pl.indevo.pi.directory.api.ico.ICOService;
import pl.indevo.pi.directory.api.ico.InvalidFormatException;

public class Configurations {
    private Parameters params;
    private Connection connection;

    public static void main(String[] args) {
        Parameters params = new Parameters(args);
        System.out.println("------------------------------------------------------------");
        System.out.println("| INDEVO.PL                                                |");
        System.out.println("| SAP PI/PO Mass ICOs Update                               |");
        System.out.println("| Version 1.0.0                                            |");
        System.out.println("------------------------------------------------------------");
        try {
            Configurations configs = new Configurations(params);
            if (params.contains("update")) {
                configs.update();
            } else {
                configs.read();
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    private void read() throws UnsupportedEncodingException, FileNotFoundException, MalformedURLException {
        ICOService icoSrv = new ICOService();
        icoSrv.setConnection(this.connection);
        icoSrv.setParameters(this.params);
        icoSrv.serialize();
        System.out.println("Done!");
    }

    private void update() throws IOException, InvalidFormatException {
        ICOService icoSrv = new ICOService();
        icoSrv.setConnection(this.connection);
        icoSrv.setParameters(this.params);
        icoSrv.update();
        System.out.println("Done!");
    }

    private Configurations(Parameters params) throws FileNotFoundException, IOException {
        if (this.invalidParams(params)) {
            System.err.println("Incorrect call parameters");
            this.printUsage();
            System.exit(1);
        }
        this.params = params;
        this.createConnection();
    }

    private void createConnection() throws FileNotFoundException, IOException {
        this.connection = new Connection();
        if (this.params.hasValue("connection")) {
            Properties connProperties = new Properties();
            connProperties.load(new FileInputStream(this.params.getString("connection")));
            this.connection.setProtocol(connProperties.getProperty("protocol"));
            this.connection.setHost(connProperties.getProperty("host"));
            this.connection.setPort(Integer.parseInt(connProperties.getProperty("port")));
            this.connection.setUsername(connProperties.getProperty("user"));
            this.connection.setPassword(connProperties.getProperty("password"));
        } else {
            this.connection.setProtocol(this.params.getString("protocol"));
            this.connection.setHost(this.params.getString("host"));
            this.connection.setPort(this.params.getInteger("port"));
            this.connection.setUsername(this.params.getString("user"));
            this.connection.setPassword(this.params.getString("password"));
        }
        System.out.println(String.format("Connecting to system: %s:%d", this.connection.getHost(), this.connection.getPort()));
    }

    private boolean invalidParams(Parameters params) {
        if (!(params.hasValue("connection") || params.hasValue("protocol") && params.hasValue("host") && params.hasValue("port") && params.hasValue("user") && params.hasValue("password"))) {
            return true;
        }
        if (!params.hasValue("update") && !params.hasValue("read")) {
            return true;
        }
        if (!(!params.hasValue("read") || params.hasValue("senderComponent") && params.hasValue("interfaceName") && params.hasValue("interfaceNS"))) {
            return true;
        }
        return params.hasValue("update") && !params.hasValue("mode");
    }

    private void printUsage() {
        System.out.println("Usage:");
        System.out.println("{-connection <properties file> | -protocol {http|https} -host <host> -port <port> -user <username> -password <password>}");
        System.out.println("{  -update <input file> -mode {full|append} | ");
        System.out.println("   -read <output file> ");
        System.out.println("     [-senderParty <party name>]");
        System.out.println("     -senderComponent <component name>");
        System.out.println("     -interfaceName <sender interface name> ");
        System.out.println("     -interfaceNS <sender interface namespace> ");
        System.out.println();
        System.out.println("Connection properties file format:");
        System.out.println("protocol={http|https}");
        System.out.println("host=<host>");
        System.out.println("port=<port>");
        System.out.println("user=<username>");
        System.out.println("password=<password>");
    }
}

