/*
 * Decompiled with CFR 0.152.
 */
package pl.indevo.pi.directory.api.ico;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import pl.indevo.pi.directory.api.ico.InvalidFormatException;

public class ConditionTokenizer {
    private ArrayList<Token> tokens = new ArrayList();
    private ListIterator<Token> iterator;
    private HashSet<String> keywords = new HashSet();
    private HashSet<Character> symbols = new HashSet();
    private Token currentToken;

    public ConditionTokenizer() {
        this.keywords.add("OR");
        this.keywords.add("AND");
        this.keywords.add("XPATH");
        this.keywords.add("EQ");
        this.keywords.add("NE");
        this.keywords.add("EX");
        this.symbols.add(Character.valueOf('('));
        this.symbols.add(Character.valueOf(')'));
        this.symbols.add(Character.valueOf(','));
    }

    public void tokenize(String expression) throws InvalidFormatException {
        char[] chars = expression.toCharArray();
        int i = 0;
        StringBuffer seq = new StringBuffer();
        boolean inLiteral = false;
        boolean escaped = false;
        block4: while (i < chars.length) {
            char ch = chars[i++];
            switch (ch) {
                case '\"': {
                    if (escaped) {
                        seq.append(ch);
                        escaped = false;
                        break;
                    }
                    if (inLiteral) {
                        this.tokens.add(new Token(seq, i, TokenType.LITERAL));
                        seq = new StringBuffer();
                        this.tokens.add(new Token("\"", i, TokenType.SYMBOL));
                    } else {
                        this.tokens.add(new Token("\"", i, TokenType.SYMBOL));
                    }
                    inLiteral = !inLiteral;
                    break;
                }
                case '\\': {
                    boolean bl = escaped = inLiteral && !escaped;
                    if (escaped) continue block4;
                    seq.append(ch);
                    break;
                }
                default: {
                    if (escaped) {
                        throw new InvalidFormatException("Unknown escape sequence: \\" + ch);
                    }
                    if (!inLiteral) {
                        if (this.symbols.contains(Character.valueOf(ch))) {
                            if (seq.length() > 0) {
                                this.tokens.add(new Token(seq, i, TokenType.KEYWORD));
                                seq = new StringBuffer();
                            }
                            this.tokens.add(new Token(String.valueOf(ch), i, TokenType.SYMBOL));
                            break;
                        }
                        seq.append(ch);
                        if (!this.keywords.contains(seq.toString())) continue block4;
                        this.tokens.add(new Token(seq, i, TokenType.KEYWORD));
                        seq = new StringBuffer();
                        break;
                    }
                    seq.append(ch);
                }
            }
        }
        if (seq.length() > 0) {
            if (inLiteral) {
                this.tokens.add(new Token(seq, i, TokenType.LITERAL));
            } else {
                this.tokens.add(new Token(seq, i, TokenType.KEYWORD));
            }
        }
        this.iterator = this.tokens.listIterator();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public String next() {
        this.currentToken = this.iterator.next();
        return this.currentToken.getValue();
    }

    public TokenType getTokenType() {
        return this.currentToken.getType();
    }

    class Token {
        private String value;
        private int startPos;
        private int endPos;
        private TokenType type;

        Token(CharSequence value, int endPos, TokenType type) {
            this.value = value.toString();
            this.endPos = endPos;
            this.startPos = endPos - value.length();
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public int getEndPos() {
            return this.endPos;
        }

        public int getStartPos() {
            return this.startPos;
        }

        public TokenType getType() {
            return this.type;
        }

        public String toString() {
            return String.format("'%s'(%d,%d,%s)", new Object[]{this.value, this.startPos, this.endPos, this.type});
        }
    }

    public static enum TokenType {
        KEYWORD,
        SYMBOL,
        LITERAL;

    }
}

