/*
 * Decompiled with CFR 0.152.
 */
package pl.indevo.pi.directory.api.ico;

import com.sap.xi.basis.AtomicCondition;
import com.sap.xi.basis.AtomicConditionBlock;
import com.sap.xi.basis.Condition;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class ConditionSerializer {
    public static String toString(Condition conditionGroup) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        if (conditionGroup.getAtomicConditionBlock().size() > 1) {
            writer.print("OR(");
        }
        int i = 0;
        while (i < conditionGroup.getAtomicConditionBlock().size()) {
            AtomicConditionBlock block = conditionGroup.getAtomicConditionBlock().get(i);
            ConditionSerializer.writeConditions(writer, block.getAtomicCondition());
            if (i < conditionGroup.getAtomicConditionBlock().size() - 1) {
                writer.print(",");
            }
            ++i;
        }
        if (conditionGroup.getAtomicConditionBlock().size() > 1) {
            writer.print(")");
        }
        return sw.toString();
    }

    private static void writeConditions(PrintWriter writer, List<AtomicCondition> conditions) {
        if (conditions.size() > 1) {
            writer.print("AND(");
        }
        int i = 0;
        while (i < conditions.size()) {
            AtomicCondition condition = conditions.get(i);
            writer.print(ConditionSerializer.condFunction(condition));
            if (i < conditions.size() - 1) {
                writer.print(",");
            }
            ++i;
        }
        if (conditions.size() > 1) {
            writer.print(")");
        }
    }

    private static String condFunction(AtomicCondition cond) {
        String leftVal = cond.getLeftExtractor().getValue();
        String leftType = cond.getLeftExtractor().getDatatype();
        if ("EX".equals(cond.getOperator())) {
            return String.format("%s(XPATH(\"%s\",\"%s\"))", cond.getOperator(), ConditionSerializer.escapeLiteral(leftVal), leftType);
        }
        String rightVal = cond.getRightExtractor().getValue();
        return String.format("%s(XPATH(\"%s\",\"%s\"),\"%s\")", cond.getOperator(), ConditionSerializer.escapeLiteral(leftVal), leftType, ConditionSerializer.escapeLiteral(rightVal));
    }

    private static String escapeLiteral(String value) {
        return value.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

