/*
 * Decompiled with CFR 0.152.
 */
package pl.indevo.pi.directory.api.ico;

import com.sap.xi.basis.AtomicCondition;
import com.sap.xi.basis.AtomicConditionBlock;
import com.sap.xi.basis.Condition;
import com.sap.xi.basis.Extractor;
import com.sap.xi.basis.ExtractorTypeCode;
import java.util.List;
import pl.indevo.pi.directory.api.ico.ConditionTokenizer;
import pl.indevo.pi.directory.api.ico.InvalidFormatException;

public class ConditionParser {
    private ConditionTokenizer tokenizer;
    private List<AtomicConditionBlock> blocks;
    private AtomicConditionBlock block;
    private AtomicCondition condition;

    public Condition parseExpression(String expression) throws InvalidFormatException {
        if (expression.trim().length() == 0) {
            return null;
        }
        Condition conditionGroup = new Condition();
        this.blocks = conditionGroup.getAtomicConditionBlock();
        this.block = new AtomicConditionBlock();
        this.blocks.add(this.block);
        this.tokenizer = new ConditionTokenizer();
        this.tokenizer.tokenize(expression);
        String token = this.nextToken();
        if ("OR".equals(token)) {
            this.parseOR();
        } else if ("AND".equals(token)) {
            this.parseAND();
        } else if ("EQ".equals(token)) {
            this.parseEQ();
        } else if ("NE".equals(token)) {
            this.parseNE();
        } else if ("CP".equals(token)) {
            this.parseCP();
        } else if ("EX".equals(token)) {
            this.parseEX();
        } else {
            throw new InvalidFormatException("Invalid condition. Expected: OR|AND|EQ|NE|CP|EX Found: " + token);
        }
        return conditionGroup;
    }

    void parseOR() throws InvalidFormatException {
        this.skip("(");
        this.parseORParameters();
    }

    void parseORParameters() throws InvalidFormatException {
        String token = this.nextToken();
        if ("AND".equals(token)) {
            this.parseAND();
        } else if ("EQ".equals(token)) {
            this.parseEQ();
        } else if ("NE".equals(token)) {
            this.parseNE();
        } else if ("CP".equals(token)) {
            this.parseCP();
        } else if ("EX".equals(token)) {
            this.parseEX();
        } else {
            throw new InvalidFormatException("Invalid condition. Expected: AND|EQ|NE|CP|EX Found: " + token);
        }
        token = this.nextToken();
        if (!",".equals(token)) {
            if (")".equals(token)) {
                return;
            }
            throw new InvalidFormatException("Invalid condition. Expected: ,|) Found: " + token);
        }
        this.block = new AtomicConditionBlock();
        this.blocks.add(this.block);
        this.parseORParameters();
    }

    void parseAND() throws InvalidFormatException {
        this.skip("(");
        this.parseANDParameters();
    }

    void parseANDParameters() throws InvalidFormatException {
        String token = this.nextToken();
        if ("EQ".equals(token)) {
            this.parseEQ();
        } else if ("NE".equals(token)) {
            this.parseNE();
        } else if ("CP".equals(token)) {
            this.parseCP();
        } else if ("EX".equals(token)) {
            this.parseEX();
        } else {
            throw new InvalidFormatException("Invalid condition. Expected: EQ|NE|CP|EX Found: " + token);
        }
        token = this.nextToken();
        if (!",".equals(token)) {
            if (")".equals(token)) {
                return;
            }
            throw new InvalidFormatException("Invalid condition. Expected: ,|) Found: " + token);
        }
        this.parseANDParameters();
    }

    void parseEQ() throws InvalidFormatException {
        this.condition = new AtomicCondition();
        this.block.getAtomicCondition().add(this.condition);
        this.condition.setOperator("EQ");
        this.skip("(");
        this.parseXPATH();
        this.skip(",");
        String value = this.literal();
        this.condition.setRightExtractor(this.createConstantExtractor(value));
        this.skip(")");
    }

    void parseNE() throws InvalidFormatException {
        this.condition = new AtomicCondition();
        this.block.getAtomicCondition().add(this.condition);
        this.condition.setOperator("NE");
        this.skip("(");
        this.parseXPATH();
        this.skip(",");
        String value = this.literal();
        this.condition.setRightExtractor(this.createConstantExtractor(value));
        this.skip(")");
    }

    void parseCP() throws InvalidFormatException {
        this.condition = new AtomicCondition();
        this.block.getAtomicCondition().add(this.condition);
        this.condition.setOperator("CP");
        this.skip("(");
        this.parseXPATH();
        this.skip(",");
        String value = this.literal();
        this.condition.setRightExtractor(this.createConstantExtractor(value));
        this.skip(")");
    }

    void parseEX() throws InvalidFormatException {
        this.condition = new AtomicCondition();
        this.block.getAtomicCondition().add(this.condition);
        this.condition.setOperator("EX");
        this.skip("(");
        this.parseXPATH();
        this.skip(")");
    }

    void parseXPATH() throws InvalidFormatException {
        this.skip("XPATH");
        this.skip("(");
        String value = this.literal();
        this.skip(",");
        String dataType = this.literal();
        this.condition.setLeftExtractor(this.createExtractor(value, dataType, ExtractorTypeCode.X_PATH));
        this.skip(")");
    }

    Extractor createConstantExtractor(String value) {
        Extractor extractor = new Extractor();
        extractor.setContextObjectName("");
        extractor.setContextObjectNamespace("");
        extractor.setTypeID(ExtractorTypeCode.CONSTANT);
        extractor.setValue(value);
        extractor.setDatatype("xsd:string");
        return extractor;
    }

    Extractor createExtractor(String value, String dataType, ExtractorTypeCode type) {
        Extractor extractor = new Extractor();
        extractor.setTypeID(type);
        extractor.setValue(value);
        extractor.setDatatype(dataType);
        return extractor;
    }

    void skip(String token) throws InvalidFormatException {
        if (!this.tokenizer.hasNext()) {
            throw new InvalidFormatException("Invalid condition. Expected: " + token);
        }
        String nextToken = this.tokenizer.next();
        if (!token.equals(nextToken)) {
            throw new InvalidFormatException(String.format("Invalid condition. Expected: %s Found: %s", token, nextToken));
        }
    }

    String literal() throws InvalidFormatException {
        this.skip("\"");
        String literal = this.nextToken();
        this.skip("\"");
        return literal;
    }

    String nextToken() throws InvalidFormatException {
        if (!this.tokenizer.hasNext()) {
            throw new InvalidFormatException("Invalid condition. Unexpected end.");
        }
        return this.tokenizer.next();
    }
}

