/*
 * Decompiled with CFR 0.152.
 */
package pl.indevo.pi.directory.api;

import com.sap.xi.basis.ChangeListCreateOut;
import com.sap.xi.basis.ChangeListIn;
import com.sap.xi.basis.ChangeListInService;
import com.sap.xi.basis.LogMessageChangeList;
import com.sap.xi.basis.LogMessageCollection;
import com.sap.xi.basis.RestrictedChangeListID;
import com.sap.xi.basis.global.LONGDescription;
import java.net.MalformedURLException;
import java.util.List;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPFaultException;
import pl.indevo.pi.directory.api.commons.Connection;

public class ChangeListService {
    private Connection connection;
    private String servicePath = "/ChangeListInService/ChangeListInImplBean";
    private ChangeListIn port;
    private List<LogMessageChangeList> messages;

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String createChangeList(String name, String description) throws MalformedURLException, SOAPFaultException {
        this.getServicePort();
        RestrictedChangeListID request = new RestrictedChangeListID();
        request.setName(name);
        LONGDescription longDescr = new LONGDescription();
        longDescr.setLanguageCode("EN");
        longDescr.setValue(description);
        request.setDescription(longDescr);
        ChangeListCreateOut result = this.getServicePort().create(request);
        return result.getChangeListID().getChangeListID();
    }

    public void activate(String changeListID) throws MalformedURLException {
        LogMessageCollection log = this.getServicePort().activate(changeListID);
        this.messages = log.getLogMessageChangeList();
        this.printMessages();
    }

    public void reject(String changeListID) throws MalformedURLException {
        LogMessageCollection log = this.getServicePort().revert(changeListID);
        this.messages = log.getLogMessageChangeList();
        this.printMessages();
    }

    private void printMessages() {
        for (LogMessageChangeList message : this.messages) {
            System.out.println(message.getLogMessageItem().getMessage().getValue());
        }
    }

    public String createChangeList(String name) throws MalformedURLException {
        return this.createChangeList(name, "");
    }

    private ChangeListIn getServicePort() throws MalformedURLException {
        if (this.port == null) {
            ChangeListInService ws = new ChangeListInService();
            this.port = ws.getChangeListInPort();
            BindingProvider bp = (BindingProvider)this.port;
            bp.getRequestContext().put("javax.xml.ws.security.auth.username", this.connection.getUsername());
            bp.getRequestContext().put("javax.xml.ws.security.auth.password", this.connection.getPassword());
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.connection.getUrlPath(this.servicePath));
        }
        return this.port;
    }
}

